<?php

namespace AgeGate\Dev\Admin\Notice;

use AgeGate\Common\Immutable\Constants;
use AgeGate\Common\Settings;

class Warning
{
    private $settings = [];

    public function __construct()
    {
        $this->settings = get_option('age_gate_dev', []);
        add_action('admin_notices', [$this, 'warning']);
    }

    public function warning()
    {

        if (($this->settings['dev_warning'] ?? false) && current_user_can(Constants::TOOLS)) {

            $data = get_plugin_data(AGE_GATE_PATH . 'age-gate.php');

            $dev = preg_split('/\-|\+/', $data['Version']);

            if ($dev[1] ?? false) {
                $pattern = sprintf('/(%s|%s)/', $dev[1], AGE_GATE_VERSION);
                /* translators: %1$s: Sub version  number. %2$s: Full version number. */
                $messageText = sprintf(__('You are using the %1$s version of Age Gate %2$s. This may not be suitable for production websites.', 'age-gate'), $dev[1], AGE_GATE_VERSION);
                echo '<div id="message" class="notice notice-error"><p>' . preg_replace($pattern, '<b>$1</b>', esc_html($messageText)) . '</p></div>';
            }
        }
    }
}